/*
  This source is part of PCOak, an electronic mailer for DOS based on PCElm.

  PCElm is Copyright (c) 1988-1993 Martin Freiss and Wolfgang Siebeck
           Copyright (c) 1992-1999 Demon Internet
  PCOak is Copyright (c) 2000 Simon Turner, Pete Disdale and dispc members

  Thanks to an agreement between the original PCElm authors and Demon Internet
  made in late 1999:

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License, version 1, as
	published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	See the file COPYING, which contains a copy of the GNU General
	Public License.
*/

/*
 * chars.h -- useful stuff for manipulating characters and sets of characters
 */

/*
 * Various useful character set string defined in miscutil.c
 */
extern const char chs_wsp[];	/* Whitespace chars (SPC, TAB, CR, LF) */
extern const char chs_lwsp[];	/* Linear-whitespace chars (SPC, TAB) */
extern const char chs_path[];	/* Path delimiter chars (':', '/', '\') */
extern const char chs_sep[];	/* Address separator chars (LWSP & ',') */

/*
 * Useful functions
 */
char *cstail(const char *s, const char *set);
char *nstail(const char *s, const char *set);
char *csskip(const char *s, const char *set);
char *nsskip(const char *s, const char *set);

/*
 * Useful macros:
 *	islwsp		Test whether (c) is an LWSP-char or not
 *	leafname	Return a pointer to the last element of path (p)
 *	kill_trail_lwsp	Truncate string (s) at trailing LWSP-chars
 *	kill_trail_wsp	Truncate string (s) at trailing whitespace
 *	kill_trail_sep	Truncate string (s) at trailing address separators
 *	skip_lwsp	Skip leading LWSP-chars in (s); return 1st non-LSWP
 *	skip_wsp	Skip leading whitespace in (s); return 1st non-wsp
 *	skip_sep	Skip leading separators in (s); return 1st non-sep
 *	first_lwsp	Skip leading non-LWSP-chars in (s); return 1st LSWP
 */
#define islwsp(c)		((c) == ' ' || (c) == '\t')
#define leafname(p)		nstail((p), chs_path)
#define kill_trail_lwsp(s)	(*cstail((s), chs_lwsp) = '\0')
#define kill_trail_wsp(s)	(*cstail((s), chs_wsp) = '\0')
#define kill_trail_sep(s)	(*cstail((s), chs_sep) = '\0')
#define skip_lwsp(s)		csskip((s), chs_lwsp)
#define skip_wsp(s)		csskip((s), chs_wsp)
#define skip_sep(s)		csskip((s), chs_sep)
#define first_lwsp(s)		nsskip((s), chs_lwsp)
