/*
  This source is part of PCOak, an electronic mailer for DOS based on PCElm.

  PCElm is Copyright (c) 1988-1993 Martin Freiss and Wolfgang Siebeck
           Copyright (c) 1992-1999 Demon Internet
  PCOak is Copyright (c) 2000-2002 Simon Turner, Pete Disdale and dispc members

  Thanks to an agreement between the original PCElm authors and Demon Internet
  made in late 1999:

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License, version 1, as
	published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	See the file COPYING, which contains a copy of the GNU General
	Public License.
*/

/*
 * commands.h -- lists of supported command characters
 */

/*
 * Define some tokens for main menu commands
 * These are related to the <valid_commands> string in main() (tcmain.c)
 *
 * These values are used in the horribly huge "switch (commandchar)" in
 * main(); the whole system is a bit of a crock.  I'll explain.
 *
 * The user's keypress is returned by getkey() (a value between 0x0001 and
 * 0x1fff, it appears from reading keyboard.h/keymake.c); if the key pressed
 * matches one of the keys linked with the CMD_* list below, then the CMD_*
 * value is used in the switch; otherwise, the actual key value as returned by
 * getkey() is used in the switch instead.  This sounds OK, so long as no
 * "raw" keys get through which have a getkey() value in the range covered by
 * CMD_* tokens; any that do clash need special processing to make sure their
 * getkey() values don't get passed through to the switch, where they would be
 * mistaken for a CMD_* token.  Some attempt had been made to handle this; CR
 * is ASCII 13, and would appear to be CMD_COLOR if it wasn't mapped to
 * CMD_READMSG, and similarly ESC and TAB were mapped to CMD_QUIT and
 * CMD_TRAWL respectively; any unmapped key below 32 (SPC) was then rejected.
 * This would have worked OK while there were less than 32 CMD_* tokens, but
 * after that it would all start to unravel.
 *
 * (Actually, I think it all started to go wrong when somebody -- probably
 * Grahame -- added the CMD_MIME token, value 27, but forgot to sort out the
 * "have we pressed ESC" check which came *AFTER* the assignation of CMD_*
 * tokens; so any attempt to use 'M' for MIME caused PCElm, and PCOak up to
 * version 0.1, to exit as though ESC had been pressed. 8-)
 *
 * As more commands were added, the range of "dangerous" characters became
 * ever larger; in PCOak up to 0.1, for instance, pressing '"' cycles the
 * pager usage just like pressing 'e' ('"' is ASCII 34; CMD_EXTPAGER is 34).
 *
 * Given that getkey() return values can be no larger than 0x1fff (the highest
 * flag bit is ENHANCE, 0x1000), it would seem to make more sense to move the
 * CMD_* token values outside the range of possible keypresses, say 0x4000 and
 * above (which are still valid for a signed integer).  That way, any keys
 * which map to a command get a CMD_* value which cannot clash with any raw
 * getkey() return value; so we don't need to jump through hoops to ward
 * against the clashes, and there will never again be a problem of a keypress
 * doing something unexpected because it matches a CMD_* token.
 */

#define CMD_BASE	0x4000		/* Base value for CMD_* tokens */

#define CMD_DELETE 	(CMD_BASE +  1)		/* d */
#define CMD_FRESHEN 	(CMD_BASE +  2)		/* F */
#define CMD_FORWARD 	(CMD_BASE +  3)		/* f */
#define CMD_REPLY_INCL 	(CMD_BASE +  4)		/* R */
#define CMD_REPLY 	(CMD_BASE +  5)		/* r */
#define CMD_SAVE	(CMD_BASE +  6)		/* s */
#define CMD_MAILTO	(CMD_BASE +  7)		/* m */
#define CMD_WRITE	(CMD_BASE +  8)		/* w */
#define CMD_LIST	(CMD_BASE +  9)		/* l */
#define CMD_UNDELETE	(CMD_BASE + 10)		/* u */
#define CMD_CHANGEMBOX	(CMD_BASE + 11)		/* c */
#define CMD_NEXTUNREAD	(CMD_BASE + 12)		/* n */
#define CMD_COLOR	(CMD_BASE + 13)		/* C */
#define CMD_REPAINT	(CMD_BASE + 14)		/* p */
#define CMD_TAG		(CMD_BASE + 15)		/* + */
#define CMD_UNTAG	(CMD_BASE + 16)		/* - */
#define CMD_TRANSMIT	(CMD_BASE + 17)		/* t */
#define CMD_QUIT	(CMD_BASE + 18)		/* Q */
#define CMD_EXIT	(CMD_BASE + 19)		/* X */
#define CMD_TOGGLE	(CMD_BASE + 20)		/* T */
#define CMD_SHELL	(CMD_BASE + 21)		/* ! */
#define CMD_NEWSOH	(CMD_BASE + 22)		/* S */
#define CMD_ABOUT	(CMD_BASE + 23)		/* a */
#define CMD_PRINTMSG	(CMD_BASE + 24)		/* P */
#define CMD_ALIASES	(CMD_BASE + 25)		/* A */
#define CMD_SEARCHSUBJ	(CMD_BASE + 26)		/* / */
#define CMD_MIME	(CMD_BASE + 27)		/* M */
#define CMD_TOGGLEHELP	(CMD_BASE + 28)		/* h */
#define CMD_GROUP_INCL 	(CMD_BASE + 29)		/* G */
#define CMD_GROUP 	(CMD_BASE + 30)		/* g */
#define CMD_MARKUNREAD	(CMD_BASE + 31)		/* U */
#define CMD_TRAWL 	(CMD_BASE + 32)		/* TAB */
#define CMD_TOGGLEWEED	(CMD_BASE + 33)		/* H */
#define CMD_EXTPAGER	(CMD_BASE + 34)		/* e */
#define CMD_READMSG	(CMD_BASE + 35)		/* SPC / CR */
#define CMD_EXTPAGREAD	(CMD_BASE + 36)		/* E */

/*
 * Default list of keys (ASCII) which map to the 35 CMD_* commands above
 *
 * Note that "\t" (ASCII 9, TAB) is used for CMD_TRAWL, but pressing the TAB
 * key will actually produce getkey() result KTAB (0x010f).  We have to map
 * this one separately; there are various other maps we have to do as well,
 * like CR to SPC (i.e. CMD_READMSG) and '$' to 'F' which I presume is
 * historical.
 */
#define DEF_COMMANDS	"dFfRrsmwlucnCp+-tQXT!SaPA/MhGgU\tHe E"
