/*
  This source is part of PCOak, an electronic mailer for DOS based on PCElm.

  PCElm is Copyright (c) 1988-1993 Martin Freiss and Wolfgang Siebeck
           Copyright (c) 1992-1999 Demon Internet
  PCOak is Copyright (c) 2000-2001 Simon Turner, Pete Disdale and dispc members

  Thanks to an agreement between the original PCElm authors and Demon Internet
  made in late 1999:

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License, version 1, as
	published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	See the file COPYING, which contains a copy of the GNU General
	Public License.
*/

#include <stdio.h>
#include <stdlib.h>
#include <dir.h>
#include <string.h>
#include <conio.h>
#include "pcoak.h"
#include "ustring.h"
#include "display.h"

/*
 * Global variables local to this module
 */
#define MAX_NAMES 50
static char *names[MAX_NAMES];
static unsigned max_names;

/*
 * External global variables used in this module
 */
extern const char no_mem[];		/* "Not enough memory" */
extern char *maildir;		/* defined mail directory */

/*
 * Functions defined and used in this module
 */
static void filedir(char *path, size_t pathsize, BOOL folders);
static int dircmp(const void *a1, const void *b1);
void folderpath(char *path, size_t pathsize, const char *foldername);
void mailboxpath(char *path, size_t pathsize, const char *mailboxname);

/*
 * Functions defined elsewhere and used in this module
 */
void backslash(char *s);
void colputs(int attr, const char *str);


/*
 * filedir()
 *
 * Display files matching pattern <path>; if there are no files or we run out
 * of memory, copy an error string into <path> (which is <pathsize> bytes long)
 * to pass it back to the calling function.  If there is no error, set <path>
 * to a null string before returning.
 */
static void filedir(char *path, size_t pathsize, BOOL folders)
{
    struct ffblk ffblk;
    char t[20];
    char *fullstop;

    max_names = 0;

    if (findfirst(path, &ffblk, FILENAME | WILDCARDS | EXTENSION) != FALSE)
    {
	PUSTRCPY(path, pathsize, "No matching files found");
	return;
    }
    *path = '\0';
    do
    {
	AUSTRCPY(t, ffblk.ff_name);
	if (!folders && (fullstop = strchr(t, '.')) != NULL)
	    *fullstop = '\0';
	if (max_names == MAX_NAMES)
	    return;	/* no more room */
	if ((names[max_names] = strdup(t)) == NULL)
	{
	    PUSTRCPY(path, pathsize, no_mem);
	    return;
	}
	max_names++;
    }
    while (findnext(&ffblk) == FALSE);
}


/*
 * dircmp()
 *
 * qsort() comparison function; just calls strcmp() for the two strings
 */
static int dircmp(const void *a1, const void *b1)
{
    return strcmp((const char *) a1, (const char *) b1);
}


/*
 * show_files()
 *
 * Show the available notefiles or folders; on entry, <pattern> contains the
 * pattern that the user wanted to see; we copy any error messages into it
 * before returning so that they can be displayed to the user.  It is
 * <patternsize> bytes long.
 */
void show_files(char *pattern, size_t patternsize)
{
    char pathname[PATHLEN];
    BOOL folders;
    unsigned i, max_width, pos;
    int n, l;
#if 0
    char title[81];
    /* title never gets used as I couldn't think of a sensible place on
       the screen to put it */
#endif

    if (*pattern == '=')	/* Folders matching <pattern + 1> */
    {
	if (strchr(pattern, '.') == NULL)
	    PUSTRCAT(pattern, patternsize, ".*");
	/* AUSTRLCPY2(title, "Folders Matching ", pattern); */
	folderpath(pathname, sizeof(pathname), pattern + 1);
	folders = TRUE;
    }
    else			/* Mailbox files matching <pattern> */
    {
	/* AUSTRLCPY2(title, "Mailboxes Matching ", pattern); */
	mailboxpath(pathname, sizeof(pathname), pattern);
	folders = FALSE;
    }
    backslash(pathname);
    filedir(pathname, sizeof(pathname), folders);
    PUSTRCPY(pattern, patternsize, pathname);	/* Copy any error message */
    if (*pathname == '\0')		/* No error: display names */
    {
	qsort(names, max_names, sizeof(char *), dircmp);
	for (n = 2; n >= 0; n--)
	{
	    gotoxy(1, display.screenheight - n);
	    clreol();
	}
	max_width = 0;
	for (i = 0; i < max_names; i++)
	{
	    unsigned len;
	    if ((len = strlen(names[i])) > max_width)
		max_width = len;
	}
	pos = 1;
	l = 2;
	for (i = 0; i < max_names; i++)
	{
	    if (pos + max_width > display.screenwidth)
		if (--l < 0)
		    break;	/* no more room on the screen */
		else
		    pos = 1;
	    gotoxy((int) pos, display.screenheight - l);
	    colputs(col_enhanc, names[i]);
	    pos += max_width + 1;
	}
    }
    for (i = 0; i < max_names; i++)
	free(names[i]);
}


/*
 * folderpath()
 *
 * Copy the full file name for folder <foldername> into <path>, which is a
 * buffer <pathsize> bytes long.  If <foldername> is NULL, just copy the
 * folder directory (with no trailing slash) into <path>.  (If you want it
 * *with* a trailing slash, just use a null string "" for <foldername>).
 */
void folderpath(char *path, size_t pathsize, const char *foldername)
{
    if (foldername)
	PUSTRLCPY5(path, pathsize, maildir, "\\", notename, "\\", foldername);
    else
	PUSTRLCPY3(path, pathsize, maildir, "\\", notename);
}


/*
 * mailboxpath()
 *
 * Copy the full file name for folder <foldername> into <path>, which is a
 * buffer <pathsize> bytes long.  If <foldername> is NULL, just copy the
 * folder directory (with no trailing slash) into <path>.  (If you want it
 * *with* a trailing slash, just use a null string "" for <foldername>).
 */
void mailboxpath(char *path, size_t pathsize, const char *mailboxname)
{
    PUSTRLCPY4(path, pathsize, maildir, "\\", mailboxname, mboxext);
}
