/*
  This source is part of PCOak, an electronic mailer for DOS based on PCElm.

  PCElm is Copyright (c) 1988-1993 Martin Freiss and Wolfgang Siebeck
           Copyright (c) 1992-1999 Demon Internet
  PCOak is Copyright (c) 2000-2002 Simon Turner, Pete Disdale and dispc members

  Thanks to an agreement between the original PCElm authors and Demon Internet
  made in late 1999:

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License, version 1, as
	published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	See the file COPYING, which contains a copy of the GNU General
	Public License.
*/

/*
 * display.h -- structures etc. to describe text display settings
 */

/*
 * A special character which, if placed at the start of a command string to be
 * executed by disp_system() (our universal front end to system()), means
 * "don't prompt the user to press a key once this command has finished"; this
 * is for internal use only, and mustn't be passed on to system() itself.
 * Obviously, this character must be illegal in both DOS and Win9x filenames,
 * so that it can never be a genuine character.
 *
 * Note that the following characters which were illegal in 8.3 FAT names are
 * legal with LFNs under Win9x and NT:
 *	<space> + , . ; = [ ]
 * (Actually, <space> was also legal in 8.3 names, so long as it had a
 * non-space character either side of it.)  Microsoft claim that only the
 * following characters are illegal in LFNs:
 *	< > : " / \ |
 * although experimentation shows that * and ? (the wildcard characters) also
 * appear to be illegal (? has a special place in the \\?\ prefix).
 */
#define NPCMD		'*'	/* Commands starting '*' get no prompt */

/*
 * Constants for the main index screen
 */
#define MAIN_TOP_LINES	2	/* Uses 2 lines at the top */
#define MAIN_BOT_LINES	4	/* Uses 4 lines at the bottom */

/*
 * A structure describing the entire display; it starts off the same as the
 * Borland text_info struct, but then adds extra information.
 *
 * All "coordinate" values are 1-based, from the top left which is position
 * (1,1); the "window" coordinates define the extent of the current text
 * window, and must be between 1 and screen{height,width} as appropriate.  The
 * cursor position is measured relative to the top left corner of this window.
 *
 * This structure is a superset of Borland's struct text_info; we can
 * therefore call gettextinfo() etc. with this structure as an argument, and
 * it should do the Right Thing.
 */
struct disp_info {
    /* Initially the same as Borland's text_info struct */
    unsigned char winleft;		/* Left window coordinate */
    unsigned char wintop;		/* Top window coordinate */
    unsigned char winright;		/* Right window coordinate */
    unsigned char winbottom;		/* Bottom window coordinate */
    unsigned char attribute;		/* Current text attribute */
    unsigned char normattr;		/* Normal attribute */
    unsigned char currmode;		/* Current text mode (BW80 etc.) */
    unsigned char screenheight;		/* Screen height in rows */
    unsigned char screenwidth;		/* Screen width in columns */
    unsigned char curx;			/* Cursor x-coordinate in window */
    unsigned char cury;			/* Cursor y-coordinate in window */
    /* New stuff from here on */
    int main_lines;			/* No. of lines avail on main screen */
};

/*
 * The current state of the display is maintained in a single global struct
 * called <display>; this should be referred to for *all* information about
 * screen sizes etc.
 */
extern struct disp_info display;

void disp_init(void);
void disp_helplines(int nlines);
void disp_fixtop(int nfixed);
void disp_fullscreen(void);
void disp_gotoxy(int x, int y);
void disp_clear(void);
BOOL color(void);
void inscursor(void);
void ovrcursor(void);
void normcursor(void);
int disp_system(const char *cmd, BOOL clear);
