/*
  This source is part of PCOak, an electronic mailer for DOS based on PCElm.

  PCElm is Copyright (c) 1988-1993 Martin Freiss and Wolfgang Siebeck
           Copyright (c) 1992-1999 Demon Internet
  PCOak is Copyright (c) 2000-2001 Simon Turner, Pete Disdale and dispc members

  Thanks to an agreement between the original PCElm authors and Demon Internet
  made in late 1999:

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License, version 1, as
	published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	See the file COPYING, which contains a copy of the GNU General
	Public License.
*/

/*
 * List of known/supported header fields for PCOak; the first part of this
 * list is used for indexes into an array of fixed strings, up to but not
 * including the NUM_FIXED_HEADERTYPES entry: entries after that are used
 * for header type which cannot be matched by a fixed string, as follows:
 *	HT_CONTENT_UNKNOWN	Unknown MIME Content-* field
 *	HT_UNKNOWN		Unknown header
 */
typedef enum headertype {
    HT_SOH,			/* Start of header: SMTP "From " */
    HT_FROM,			/* RFC [2]822 "From:" field */
    HT_REPLYTO,			/* RFC [2]822 "Reply-To:" field */
    HT_DATE,			/* RFC [2]822 "Date:" field */
    HT_TO,			/* RFC [2]822 "To:" field */
    HT_CC,			/* RFC [2]822 "Cc:" field */
    HT_BCC,			/* RFC [2]822 "Bcc:" field */
    HT_MSGID,			/* RFC [2]822 "Message-ID:" field */
    HT_SUBJECT,			/* RFC [2]822 "Subject:" field */
#if 0	/* Will be needed later */
    HT_INREPLYTO,		/* RFC 2822 "In-Reply-To:" field */
    HT_REFERENCES,		/* RFC 2822 "References:" field */
#endif
    HT_STATUS,			/* Non-RFC "Status:" field */
    HT_MIME_VERSION, 		/* MIME "MIME-Version:" field */
    HT_CONTENT_TYPE,		/* MIME "Content-Type:" field */
    HT_CONTENT_XFER_ENCODING,	/* MIME "Content-Transfer-Encoding:" field */
    HT_CONTENT_ID,		/* MIME "Content-ID:" field */
    HT_CONTENT_DESCRIPTION,	/* MIME "Content-Description:" field */
    HT_CONTENT_DISPOSITION,	/* MIME "Content-Disposition:" field */
    /**/
    NUM_FIXED_HEADERTYPES,	/* >>>MUST<<< come after last fixed string */
    /**/
    HT_CONTENT_UNKNOWN,		/* Unknown MIME "Content-*:" field */
    HT_UNKNOWN			/* Unknown header */
} HEADERTYPE;

extern const char *headername[];
