/*
  This source is part of PCOak, an electronic mailer for DOS based on PCElm.

  PCElm is Copyright (c) 1988-1993 Martin Freiss and Wolfgang Siebeck
           Copyright (c) 1992-1999 Demon Internet
  PCOak is Copyright (c) 2000-2002 Simon Turner, Pete Disdale and dispc members

  Thanks to an agreement between the original PCElm authors and Demon Internet
  made in late 1999:

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License, version 1, as
	published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	See the file COPYING, which contains a copy of the GNU General
	Public License.
*/

/*
 * Provide help for the casual user
 */

#define SHOW_CORE

#include <stdio.h>
#include <conio.h>
#ifdef SHOW_CORE
#include <alloc.h>
#endif
#include "pcoak.h"
#include "display.h"
#include "macros.h"

/*
 * Global variabled defined elsewhere and used here
 */
extern const char version_fmt[];	/* printf() fmt string: 1 string arg */

/*
 * Lines for the main help screen; apologies for the binary ^B characters,
 * which turn highlighting on and off in writef() and pokewrite()
 */
static char *help_text[] = {
" The following commands are available at the 'Command:' prompt:",
"",
" \2a\2   \2a\2bout PCElm                    \2c\2   \2c\2hange the mailboxfile",
" \2C\2   toggle \2C\2olour                  \2d\2   \2d\2elete a message",
" \2f\2   \2f\2orward a message              \2F\2   \2F\2reshen, read mailbox again",
" \2l\2   \2l\2ist unsent messages           \2m\2   send \2m\2ail",
" \2n\2   go to \2n\2ext unread message      \2p\2   \2p\2aint screen again if corrupted",
" \2P\2   \2P\2rint mail to printer          \2Q/ESC \2\2Q\2uit, save changes ",
" \2r\2   \2r\2eply to a message             \2R\2   \2R\2eply including original message",
" \2g\2   \2g\2roup reply to a message       \2G\2   \2G\2roup including original message",
" \2s\2   \2s\2ave message with header       \2S\2   new \2S\2tart of header",
" \2t\2   \2t\2ransmit message from file     \2T\2   \2T\2oggle mailsystem (Internet/UUCP)",
" \2u\2   \2u\2ndelete message               \2U\2   \2U\2nread - Mark a msg as Not read",
" \2w\2   \2w\2rite message to file, no header",
" \2X\2   e\2X\2it, don't save changes       \2!\2   execute a DOS command",
" \2A\2   edit \2A\2liases                   \2/\2   search for reg. expr. in subject",
" \2h\2   Toggle \2h\2elp mode - display four line help menu",
" \2TAB\2 Takes you into view the next unread message",
"",
"Use \2\030\031\2, \2PgUp\2, \2PgDn\2, \2Home\2, \2End\2 to position the bar,",
"\2+\2 and \2-\2 to tag/untag a message for various commands.",
"All message commands work with the highlighted/tagged message.",
"Hit [\2cr\2] to read the message, [\2Del\2] to delete, [\2Ins\2] to undelete.",
"[\2F2\2] toggles direct screen write / BIOS write.",
};

/*
 * A list of "About" text lines to follow the basic version information; we
 * actually overwrite the very last line of the stuff from version_fmt[]
 * (which contains text), so it is important that the *first* line of this
 * text contains enough spaces to clear that line (74 spaces required).
 * Subsequent lines have no need for this padding.
 *
 * The first line of this text will appear at line 16 on the screen; we are
 * therefore limited to 9 lines of text here (using screen lines 1-24 only).
 */
static char *about_text[] = {
"                                                                            ",
"The Demon Internet version of PCElm was extensively developed by",
"Grahame Davies, and latterly by Demon Internet.",
"",
"PCOak is being developed by Simon Turner (simon@twoplaces.co.uk) and",
"Pete Disdale (pete@papadelta.co.uk) with assistance from the denizens",
"of the demon.ip.support.pc newsgroup.",
};

#define ABOUT_START	16	/* Display of about_text[] starts at line 16 */

/*
 * Functions defined elsewhere and used in this module
 */
void get_cr(const char *msg);
void writef(int x, int y, int attr, const char *line);
char *seqstr(size_t n, char ch);
void quickcenter(int line, int attr, const char *txt);


/*
 * Main help screen
 */
void help(void)
{
    int i;

    clrscr();
    quickcenter(1, col_heading, help_text[0]);
    for (i = 1; i < 19; i++)
    {
	writef(1, i + 1, col_heading, seqstr(display.screenwidth, ' '));
	writef(1, i + 1, col_heading, help_text[i]);
    }
    for (; i < 24; i++)
	quickcenter(i + 1, col_heading, help_text[i]);
    get_cr(NULL);
}


/*
 * about()
 *
 * Display information about this program, which must fit on a standard 80x25
 * screen.  The old PCElm approach was to print the full global version_fmt[]
 * info, then overwrite the bottom few lines (containing the "thanks to Dave
 * Taylor" and source availability parts) with about_text[] from above,
 * starting at line 10 (so only the first 9 lines of version_fmt[] were
 * visible in the end).  We want/need to have the first 14 lines of
 * version_fmt[] visible now, to include the GNU manifesto stuff and note
 * about source availability; we give credit to Grahame Davies and Demon
 * Internet (specifically Richard Clayton) as the authors of the Demon-branded
 * PCElm that preceded PCOak.
 */
void about(void)
{
    int i;

    textattr(col_normal);
    clrscr();
    cprintf(version_fmt, myversion);
    for (i = 0; i < (int) NELEM(about_text); i++)
    {
	gotoxy(1, ABOUT_START + i);
	cputs(about_text[i]);
    }
#ifdef SHOW_CORE
    {
	char str[64];
	i++;
	sprintf(str, "Memory left: %lu bytes", farcoreleft());		/*OK*/
	gotoxy(1, ABOUT_START + i++);
	cputs(str);
    }
#endif
    get_cr(NULL);
}
