/*
  This source is part of PCOak, an electronic mailer for DOS based on PCElm.

  PCElm is Copyright (c) 1988-1993 Martin Freiss and Wolfgang Siebeck
           Copyright (c) 1992-1999 Demon Internet
  PCOak is Copyright (c) 2000-2002 Simon Turner, Pete Disdale and dispc members

  Thanks to an agreement between the original PCElm authors and Demon Internet
  made in late 1999:

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License, version 1, as
	published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	See the file COPYING, which contains a copy of the GNU General
	Public License.
*/

/*
 * Disk error handler according to the TC manual page 197
 */
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include "pcoak.h"		/* for BOOL typedef */

#pragma warn -par

#define IGNORE	0
#define RETRY	1
//#define ABORT	2

/*
 * Global variables local to this module
 */
static int last_drive = -1;
static int last_errval = -1;

/*
 * Functions defined and used here
 */
void harderr_reset(void);

/*
 * Functions defined elsewhere and used here
 */
BOOL y_n(const char *msg);


/*
 * harderr_handler()
 *
 * Handler for Int 24 hardware (disk or other device) errors
 *
 * We will catch printer errors here via the Abort, Retry, Ignore interrupt
 *
 * (But will we? Printer errors are presumably "device errors", so just get
 * ignored by the original code; we mimic this behaviour, but I'm not
 * convinced it's the right thing to do.  FIXME!)
 *
 * Critical disk errors seem rather odd under Win98, at any rate; you can set
 * the return value to ABORT, RETRY or IGNORE (which probably actually means
 * "Fail", which replaced "Ignore" in DOS 3.3); ABORT calls Int 23 to shut the
 * whole program down with no warning -- which we used to do after a total of
 * 20 errors, which was a remarkably silly thing to do IMHO; RETRY just has
 * another go; but IGNORE seems to have one retry, then -- if we do IGNORE
 * again -- it finally returns an error code to the program.  We've now given
 * up on the "count the number of errors" bit; what we do is maintain an "are
 * we supposed to be ignoring this error?" flag, which gets set if the user
 * chooses IGNORE, and is used without further prompting after that, but which
 * gets reset by a call to harderr_reset() every time we're waiting for a key
 * to be pressed at the main index screen (and possibly elsewhere).
 */
/*ARGSUSED*/
int harderr_handler(int errval, int ax, int bp, int si)
{
    int drive;
    char errtxt[80], errdesc[32];
    const char *errdp;

    if (ax < 0)				/* Device error: just ignore it */
	hardresume(IGNORE);
    drive = (ax & 0x00ff);		/* Disk error: note drive no. */
    if (drive == last_drive && errval == last_errval)	/* Same error */
	return IGNORE;			/* Ignore this one again */
    switch (errval)
    {
    case 0x00:
	errdp = "Write protect";
	break;
    case 0x02:
	errdp = "Drive not ready";
	break;
    default:
	sprintf(errdesc, "Code %02x", errval);				/*OK*/
	errdp = errdesc;
	break;
    }
    sprintf(errtxt, "%.32s error on drive %c: Retry? ",			/*OK*/
	    errdp, 'A' + drive);
    if (y_n(errtxt))		/* Retry */
    {
	(void) kbhit();		/* Allow the screen update (don't ask why!) */
	harderr_reset();
	return RETRY;
    }
    /* Keep ignoring this error for this drive until harderr_reset() called */
    (void) kbhit();		/* Allow the screen update (don't ask why!) */
    last_drive = drive;
    last_errval = errval;
    return IGNORE;
}


/*
 * harderr_reset()
 *
 * Reset the hardware error count
 */
void harderr_reset(void)
{
    if (last_drive >= 0)
	last_drive = last_errval = -1;
}
