/*
  This source is part of PCOak, an electronic mailer for DOS based on PCElm.

  PCElm is Copyright (c) 1988-1993 Martin Freiss and Wolfgang Siebeck
           Copyright (c) 1992-1999 Demon Internet
  PCOak is Copyright (c) 2000 Simon Turner, Pete Disdale and dispc members

  Thanks to an agreement between the original PCElm authors and Demon Internet
  made in late 1999:

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License, version 1, as
	published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	See the file COPYING, which contains a copy of the GNU General
	Public License.
*/

/*
 * keyboard.h, defines keycodes like Kermit
 */

/* Kermit-MS keyboard shift flags (most significant byte of key_ident) */
#define SCAN    	0x0100  /* scan code */
#define SHIFT   	0x0200  /* left or right shift */
#define CONTROL 	0x0400  /* Ctrl shift */
#define ALT     	0x0800  /* Alt shift */
#define ENHANCE 	0x1000  /* Enhanced keyboard special key */

#define KCR		0x000d
#define KLF		0x000a
#define LBS		0x0008
#define KESC		0x001b
#define CTRL_U		0x0015
#define KSPACE		0x0020
#define KALTESC		0x0901
#define KALTRET		0x091c
#define KBS		0x010e

/* F1 to F12 */
#define KF1		0x013b
#define KF2		0x013c
#define KF3		0x013d
#define KF4		0x013e
#define KF5		0x013f
#define KF6		0x0140
#define KF7		0x0141
#define KF8		0x0142
#define KF9		0x0143
#define KF10		0x0144
#define KF11		0x0185
#define KF12		0x0186

/* Shift-F1 to Shift-F12 */
#define KSF1		0x0354
#define KSF2		0x0355
#define KSF3		0x0356
#define KSF4		0x0357
#define KSF5		0x0358
#define KSF6		0x0359
#define KSF7		0x035a
#define KSF8		0x035b
#define KSF9		0x035c
#define KSF10		0x035d
#define KSF11		0x0387
#define KSF12		0x0388

/* Ctrl-F1 to Ctrl-F12 */
#define KCF1		0x055e
#define KCF2		0x055f
#define KCF3		0x0560
#define KCF4		0x0561
#define KCF5		0x0562
#define KCF6		0x0563
#define KCF7		0x0564
#define KCF8		0x0565
#define KCF9		0x0566
#define KCF10		0x0567
#define KCF11		0x0589
#define KCF12		0x058a

/* Alt-F1 to Alt-F12 */
#define KAF1		0x0968
#define KAF2		0x0969
#define KAF3		0x096a
#define KAF4		0x096b
#define KAF5		0x096c
#define KAF6		0x096d
#define KAF7		0x096e
#define KAF8		0x096f
#define KAF9		0x0970
#define KAF10		0x0971
#define KAF11		0x098b
#define KAF12		0x098c

/* Now the Enhanced keyboard cursor keys */
#define KINS		0x1152
#define KDEL		0x1153
#define KHOME		0x1147
#define KEND		0x114f
#define KPGUP		0x1149
#define KPGDN		0x1151
#define KUP		0x1148
#define KDN		0x1150
#define KLFT		0x114b
#define KRGT		0x114d

/* PgUp/PgDn with Ctrl */
#define CKPGUP		0x1584
#define CKPGDN		0x1576
#define CKKP9		0x0584
#define CKKP3		0x0576

/* Left/Right with Ctrl */
#define CKLFT		0x1573
#define CKKP4		0x0573
#define CKRGT		0x1574
#define CKKP6		0x0574

#define KTAB		0x010f
#define KSHTAB		0x030f

#define KKPDIV		0x112d
#define KKPMULT		0x0137
#define KKPMINUS	0x014a
#define KKPPLUS		0x014e
#define KKPENTER	0x110d

/* The keypad, first without Num Lock ... */
#define KKP0		0x0152
#define KKPCOMMA	0x0153
#define KKP1		0x014f
#define KKP2		0x0150
#define KKP3		0x0151
#define KKP4		0x014b
#define KKP5		0x014c
#define KKP6		0x014d
#define KKP7		0x0147
#define KKP8		0x0148
#define KKP9		0x0149

/* ... then with Num Lock */
#define KNUM0		0x0352
#define KNUMCOMMA	0x002c
#define KNUM1		0x034f
#define KNUM2		0x0350
#define KNUM3		0x0351
#define KNUM4		0x034b
#define KNUM5		0x034c
#define KNUM6		0x034d
#define KNUM7		0x0347
#define KNUM8		0x0348
#define KNUM9		0x0349

/* The whole alphabet with Alt */
#define ALTA		0x091e
#define ALTB		0x0930
#define ALTC		0x092e
#define ALTD		0x0920
#define ALTE		0x0912
#define ALTF		0x0921
#define ALTG		0x0922
#define ALTH		0x0923
#define ALTI		0x0917
#define ALTJ		0x0924
#define ALTK		0x0925
#define ALTL		0x0926
#define ALTM		0x0932
#define ALTN		0x0931
#define ALTO		0x0918
#define ALTP		0x0919
#define ALTQ		0x0910
#define ALTR		0x0913
#define ALTS		0x091f
#define ALTT		0x0914
#define ALTU		0x0916
#define ALTV		0x092f
#define ALTW		0x0911
#define ALTX		0x092d
#define ALTY		0x0915
#define ALTZ		0x092c

/* The normal numbers from 1 to 0 with Alt */
#define ALT1		0x0978
#define ALT2		0x0979
#define ALT3		0x097a
#define ALT4		0x097b
#define ALT5		0x097c
#define ALT6		0x097d
#define ALT7		0x097e
#define ALT8		0x097f
#define ALT9		0x0980
#define ALT0		0x0981
