/*
  This source is part of PCOak, an electronic mailer for DOS based on PCElm.

  PCElm is Copyright (c) 1988-1993 Martin Freiss and Wolfgang Siebeck
           Copyright (c) 1992-1999 Demon Internet
  PCOak is Copyright (c) 2000-2001 Simon Turner, Pete Disdale and dispc members

  Thanks to an agreement between the original PCElm authors and Demon Internet
  made in late 1999:

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License, version 1, as
	published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	See the file COPYING, which contains a copy of the GNU General
	Public License.
*/

/*
 * New keypress check, compatible with KERMIT.  The benefit is that we can
 * tell the difference between the normal arror keys and the numeric keypad
 * ones.
 */

#ifdef TEST__
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#endif

#include <dos.h>
#include <conio.h>
#include "keyboard.h"

#define BS	0x08
#define TAB	0x09
#define CR	0x0d

/*
 * This function should match 'getkey' in MSUIBM.ASM.
 *
 * Kermit-MS determines the 'key ident' from the value returned in ax
 * (ah=scan code, al=ascii value) from BIOS call 0x16 function 0
 * (standard keyboard) or 0x10 (enhanced keyboard), the
 * status of various shift keys, and a table of special keys (aliaskey).
 * The aliaskey table handles cases where more than one key may generate
 * the same ascii value (i.e. the numeric keypad).  The entries in table
 * aliaskey are words with the high byte holding a scan code and the low
 * byte holding an ascii value.  The general method is as follows:
 *
 *    BIOS int 0x16 function 0 or 0x10   returns key's code in register ax.
 *    if (ah!=0 and al=0xe0)             enhanced
 *       al = 0                          zero ascii
 *       key_ident |= ENHANCE            set enhanced flag
 *    else if (ah==0xe0)                 enhanced
 *       ah=al                           put scan in ah
 *       al=0                            zero ascii
 *       key_ident |= ENHANCE            set enhanced flag
 *    if (ax is in aliaskey list)
 *       al = 0                    clear normal ascii to simulate special key
 *    ascii = al                         do this in either case
 *    if ( ascii == 0 ) {                now, if the key is a special one ...
 *    scancode = ah                      work with scan code instead
 *       key_ident = scancode + SCAN     set SCAN code flag bit
 *       if ( LeftShift || RightShift || (NumKeypadWhiteKey && NumLock) )
 *          key_ident |= SHIFT           set smart SHIFT key flag bit
 *       if ( Ctrl )
 *          key_ident |= CONTROL         set CONTROL key flag bit
 *       If ( Alt )
 *          key_ident |= ALT             set ALT key flag bit
 *    } else
 *       key_ident = ascii
 */
static unsigned int kerm_key(unsigned int bios_key, unsigned int bios_shifts)
{
    unsigned  key_id;

    key_id = 0;
    /* getky1a */
    if ((bios_key & 0xff00) != 0)		/* not alt-numeric */
    {
	if ((bios_key & 0xff00) == 0xe000)
	{
	    bios_key <<= 8;
	    key_id |= ENHANCE;
	}
	/* getky1b */
	if ((bios_key & 0x00ff) == 0x00e0)
	{
	    bios_key &= 0xff00;
	    key_id |= ENHANCE;
	}
    }
    if (bios_key == CR * SCAN)
	bios_key = CR;
    if (bios_key == '/' * SCAN)
	bios_key = '/';
    if ((bios_key & 0x00ff) != 0)		/* not scan code only */
    {
	/* getky1c */
	/* aliaskey processing */
	switch (bios_key)
	{
	case (55 * SCAN) + '*':
	    key_id = '*';
	    break;
	case (74 * SCAN) + '-':
	    key_id = '-';
	    break;
	case (78 * SCAN) + '+':
	    key_id = '+';
	    break;
	case (71 * SCAN) + '7':
	    key_id = '7';
	    break;
	case (72 * SCAN) + '8':
	    key_id = '8';
	    break;
	case (73 * SCAN) + '9':
	    key_id = '9';
	    break;
	case (75 * SCAN) + '4':
	    key_id = '4';
	    break;
	case (76 * SCAN) + '5':
	    key_id = '5';
	    break;
	case (77 * SCAN) + '6':
	    key_id = '6';
	    break;
	case (79 * SCAN) + '1':
	    key_id = '1';
	    break;
	case (80 * SCAN) + '2':
	    key_id = '2';
	    break;
	case (81 * SCAN) + '3':
	    key_id = '3';
	    break;
	case (82 * SCAN) + '0':
	    key_id = '0';
	    break;
	case (83 * SCAN) + '.':
	    key_id = '.';
	    break;
	case (14 * SCAN) + BS:
	case (15 * SCAN) + TAB:
	    bios_key &= 0xff00;	/* clear ascii low byte */
	    break;
	default:			/* key is not in the list */
	    break;
	};
    }
    if ((bios_key & 0x00ff) == 0)
    {				/* No ASCII value, get a kermit scan code. */
	key_id |= ((bios_key >> 8) | SCAN);	/* set scancode flag */
	if (bios_shifts & 3)			/* left or right shift?*/
	    key_id |= SHIFT;			/* yes, set shift flag */
	else if ((bios_shifts & 0x20)		/* NumLock set? */
		 && (key_id >= (71 + SCAN))	/* on numeric keypad ? */
		 && (key_id <= (83 + SCAN))
		 && (key_id != (74 + SCAN))	/* not the grey - key? */
		 && (key_id != (78 + SCAN)))	/* not the grey + key? */
	    key_id |= SHIFT;			/* all true, set shift */
	if (bios_shifts & 0x04)			/* Ctrl-key pressed? */
	    key_id |= CONTROL;
	if (bios_shifts & 0x08)			/* Alt-key pressed? */
	    key_id |= ALT;
    }
    else			/* We have an ASCII value,  return that */
	key_id = bios_key & 0xff;
    return key_id;
}


static unsigned int kbioskey(int function)  /* For most C compilers [jrd] */
{					    /* do Interrupt 16H via int86() */
    _AH = (char) function;
    __int__(0x16);
    return _AX;
}


/*
 * getkey()
 *
 * If there's a keypress waiting, find the key and the shift states, transform
 * them into the appropriate "Kermit" style value, and return that value.
 *
 * If we're running under Windows (established the first time this function is
 * called), call interrupt ???? to let Windows get a look in; this improves
 * responsiveness.  (Used to be a modified version of kbhit(); code moved to
 * here to avoid depending on the Borland RTL source.)
 */
unsigned int getkey(void)
{
    static int firstcall = 1,		/* only check first time called */
	DPMI_service_avbl = 0;		/* ... to set this var */

    if (firstcall)
    {
	asm	mov	ax, 1680h
	asm	int	2fh
	DPMI_service_avbl = (_AL == 0);
	firstcall = 0;
    }
    else if (DPMI_service_avbl)
    {
	asm	mov	ax, 1680h
	asm	int	2fh
    }

    if (!kbhit())
	return 0;
    return kerm_key(kbioskey(peekb(0x40, 0x96) & 0x10), kbioskey(2));
}


#ifdef TEST__
void main(int argc, char *argv[])
{
    FILE *h_file;
    char desc[20];
    unsigned int key;

    if ((h_file = fopen(argv[1], "w")) == NULL)
    {
	printf("Can not open [%s].\n", argv[1]);
	exit(1);
    }
    printf("Give description *** to finish!\n");
    do
    {
	key = getkey();
	printf("Id for key with code %04x : ", key);
	desc[0] = '\0';
	gets(desc);
	if (desc[0] != '\0')
	    fprintf(h_file, "#define %s\t\t0x%04x\n", desc, key);
	if (!strcmp(desc, "***"))
	    break;
    }
    while (1);
    fclose(h_file);
}
#endif
