/*
  This source is part of PCOak, an electronic mailer for DOS based on PCElm.

  PCElm is Copyright (c) 1988-1993 Martin Freiss and Wolfgang Siebeck
           Copyright (c) 1992-1999 Demon Internet
  PCOak is Copyright (c) 2000-2001 Simon Turner, Pete Disdale and dispc members

  Thanks to an agreement between the original PCElm authors and Demon Internet
  made in late 1999:

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License, version 1, as
	published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	See the file COPYING, which contains a copy of the GNU General
	Public License.
*/

#include <dos.h>

#define DOSPRINT 	1
#define MULTIPLEX	0x2F

/*
 * find out if the resident portion of the DOS print spooler is loaded
 */
int print_loaded()
{
    union REGS  regs;

    regs.h.ah = DOSPRINT;
    regs.h.al = 0;
    int86(MULTIPLEX, &regs, &regs);
    return (regs.h.al == 0xFF);
}


/*
 * submit a filename to PRINT for addition to the queue
 * The returned value is the value returned in AL by PRINT
 *	AL = 158 - filename accepted and now printing
 *	AL = 1	 - filename accepted and added to queue
 * if the carry flag indicates an error, -1 is returned
 */
int print_file(char far *filename)
{
    static struct submit_packet {	/*lint -esym(550,submit) */ /* OK */
	unsigned char level;
	char far *p;
    } submit;
    struct REGPACK regs;

    regs.r_ax = 0x0101;		/* Queue file */
    submit.level = 0;		/* don't know what this is for but it is needed */
    submit.p = filename;	/* make a far pointer to filename in DS:DX */
    regs.r_ds = FP_SEG(&submit);			/*lint !e507*/ /*OK*/
    regs.r_dx = FP_OFF(&submit);
    /* NOTE: the above line gives a pointer warning */
    intr(MULTIPLEX, &regs);
    if (regs.r_flags != 0)
	return -1;		/* error */
    else
	return (int) regs.r_ax;
}
