/*
  This source is part of PCOak, an electronic mailer for DOS based on PCElm.

  PCElm is Copyright (c) 1988-1993 Martin Freiss and Wolfgang Siebeck
           Copyright (c) 1992-1999 Demon Internet
  PCOak is Copyright (c) 2000-2001 Simon Turner, Pete Disdale and dispc members

  Thanks to an agreement between the original PCElm authors and Demon Internet
  made in late 1999:

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License, version 1, as
	published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	See the file COPYING, which contains a copy of the GNU General
	Public License.
*/

/*
 * pcoak.h -- definitions for PCOak that aren't included elsewhere
 *
 * This is slowly being tidied up, to move stuff that isn't generally used out
 * of this file; since almost everything includes this file, it should only be
 * used for declaring really heavily used stuff!
 */

#ifndef PCOAK_H_INC
#define PCOAK_H_INC

/* Number of optional headers */
#define MAXOPTHDR	10

/* External pager options ("extpager") */
#define EP_INTONLY	0	/* 0: use internal pager only */
#define EP_EXTMOSTLY	1	/* 1: use external; offer internal sometimes */
#define EP_EXTONLY	2	/* 2: use external pager only */
#define NUM_EXTPAGER	3	/* 0, 1, 2 */

/* Header weeding levels ("weedlevel" options) */
#define HW_FULL		0	/* level 0: show full headers */
#define HW_WEEDED	1	/* level 1: show weeded headers */
#define HW_SUMMARY	2	/* level 2: show summary headers */
#define HW_NONE		3	/* level 3: don't show any header fields */
#define NUM_WEEDLEVEL	4

/* Used Mailsystem */
#define SYS_HAM		0
#define SYS_UUCP 	1
#define NUM_SYSTEMS	2	/* Handle this many SYS_* types */

/* Array sizes */
#define FNAMELEN	13	/* Space for 8.3 filename */
#define PATHLEN		260	/* Space for a full path (DOS limit 144?) */
#define FOLDERLEN	64	/* Space for a folder name */
#define SLINELEN	64	/* "Short" line */
#define LINELEN		256	/* "Normal" line */
#define LLINELEN	1024	/* "Long" line */

/* The truth of the matter */
#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif

/* Frequently used character values */
#define ESC	27

/* savemsg() processing options (MIME decoding, quoting, forwarding etc.) */
#define SM_NONE		0x0000	/* No processing at all */
#define SM_DECODE	0x0001	/* Decode any MIME encodings while saving */
#define SM_QUOTE	0x0002	/* Quote each line with quote string */
#define SM_FORWARD	0x0004	/* Is this message being forwarded? */

/* System-wide typedefs */
typedef int BOOL;

/* Global 'sortby' settings */
typedef enum sortbytype {
    SORT_INCOMING,
    SORT_DATE
} SORTBYTYPE;

/* Mail message sending types */
typedef enum sendtype {
    SEND_NEWMSG,	/* Create a new message from scratch */
    SEND_FILE,		/* Send the contents of file, encoded if appropriate */
    SEND_FWDQUOTE,	/* Forward a message to someone, quoting it */
    SEND_REPLYQUOTE	/* Reply to existing message, quoting the original */
} SENDTYPE;

/************************************************************************/

/*
 * A single message is described by an HTL structure; every message in the
 * currently loaded mailbox gets one of these.  (The old name, which doesn't
 * seem particularly meaningful, is retained for historical reasons.)
 *
 * For obvious reasons, it is useful to keep the size of this structure as
 * small as possible -- but, for compilation with BC++ 3.1, it pays to
 * remember that memory is allocated in paragraphs of 16 bytes, after BC++
 * has added 4 bytes to the required allocation for its own heap management.
 * This means that a 12-byte requirement will use 16 bytes of memory, but
 * a 13-byte requirement will use 32 bytes!
 *
 * Specifically, this means that "break" points on the size of HTL are:
 *	12/13, 28/29, 44/45, 60/61, 76/77, 92/93, 108/109, ...
 * This means, for instance, that we need to think carefully about whether
 * it's worth compiling with -b- (use char for enum where possible), as it
 * tends to increase the code size but won't reduce the HTL footprint unless
 * you're < 2 bytes over a break point!
 *
 * More work will be done on this ASAP.
 */

#define MSGISTAGGED(m)	(((m)->status & S_ISTAGGED) != 0)

/* Bit-flag settings for HTL.status (8 possible flags) */
#define	S_DELETE		0x0001
#define	S_READ			0x0002
#define	S_MIME			0x0004
#define S_ISTAGGED		0x0080	/* Why 0080?  Why not 0008?  8000? */

/* Bit-flag settings for HTL.headers (8 possible flags) */
#define H_DATE			0x0001
#define H_FROM			0x0002
#define H_SUBJECT		0x0004
#define H_REPLYTO		0x0008
#define H_CONTENT_TYPE		0x0010
#define H_CONTENT_XFER_ENCODING	0x0020
#define H_MIME_VERSION		0x0040

/* Known settings for HTL.content_type */
typedef enum cttype {
    CT_NONE,			/* no type (treat as CT_TEXT_ASCII) */
    CT_UNKNOWN,			/* unknown type (treat as CT_APP_OCTET) */
    CT_TEXT_PLNASCII,		/* text/plain; charset=us-ascii */
    CT_TEXT_PLN88591,		/* text/plain; charset=iso-8859-1 */
    CT_TEXT_RICH, 		/* text/richtext or text/enriched */
    CT_TEXT_HTML, 		/* text/html */
    CT_TEXT_MISC, 		/* text/<*> (as CT_TEXT_PL* or CT_APP_OCTET) */
    CT_IMAGE_GIF,		/* image/gif */
    CT_IMAGE_JPEG,		/* image/jpeg */
    CT_IMAGE_MISC,		/* image/<*> (treat as CT_APP_OCTET) */
    CT_AUDIO_AU,		/* audio/au */
    CT_AUDIO_MISC,		/* audio/<*> (treat as CT_APP_OCTET) */
    CT_VIDEO_MPEG,		/* video/mpeg */
    CT_VIDEO_MISC,		/* video/<*> (treat as CT_APP_OCTET) */
    CT_APP_OCTET,		/* application/octet-stream */
    CT_APP_MISC,		/* application/<*> (as CT_APP_OCTET) */
    CT_MULTI_MIXED,		/* multipart/mixed */
    CT_MULTI_ALTERN,		/* multipart/alternative */
    CT_MULTI_DIGEST,		/* multipart/digest */
    CT_MULTI_MISC,		/* multipart/<*> (treat as CT_MULTI_MIXED) */
    CT_MSG_RFC822,		/* message/rfc822 */
    CT_MSG_DELIVSTAT,		/* message/delivery-status */
    CT_MSG_MISC			/* message/<*> (treat as APP_OCTET) */
} CTTYPE;

/* possible values for HTL.content_encoding */
typedef enum cetype {
    CE_NONE,			/* no encoding (treat as CE_7BIT) */
    CE_UNKNOWN,			/* unknown encoding (treat as CE_7BIT)*/
    CE_7BIT,			/* 7bit (identity) */
    CE_8BIT,			/* 8bit (identity) */
    CE_BINARY,			/* binary (identity) */
    CE_QUOTED,			/* quoted-printable */
    CE_BASE64,			/* base64 */
    CE_UUENCODE			/* x-uuencode (non-MIME) */
} CETYPE;

typedef struct htextline {
    struct htextline *prev;	/* Pointer to previous item in list */
    struct htextline *next;	/* Pointer to next item in list */
    int msgno;			/* Message number, mailbox order (1-based) */
    int listno;			/* Message number, list order (1-based) */
    unsigned char status;	/* Message status flags (S_*) */
    unsigned char headers;	/* Header-present flags (H_*) */
    long position;		/* File position of start of message */
    long size;			/* Length of message */
    char *from;			/* Pointer to malloc'd "From:" field body */
    char subject[36];		/* Truncated "Subject:" field body */
    long utc;			/* "Date:" timestamp in UTC, time_t format */
    short offmins;		/* UTC -> message time offset, in minutes */
    CTTYPE content_type;	/* Content-Type setting */
    CETYPE content_encoding;	/* Content-Transfer-Encoding setting */
} HTL, *PHTL;
typedef const HTL *PCHTL;

#if (sizeof(HTL) > 76)				/*lint !e677*/ /* OK */
#error HTL struct exceeds 76 bytes!
#endif

/************************************************************************/

/*
 * Global variable declarations (this comment originally said "definitions",
 * which says a lot... sigh)
 *
 * I'm trying to keep the number of these "globally declared" extern variables
 * to a minimum: the current criterion is that they need to be used in at
 * least 3 modules excluding (a) config.c, and (c) tcmain.c if the only use
 * therein is to define the variable.
 *
 * What I'd *really* like to do is to stop defining things in tcmain.c unless
 * they are actually used there; variables that are only used outside tcmain.c
 * should be defined in one of the modules that uses them.  ST-FIXME!
 */

/* tcmain.c */
extern BOOL enablemime;		/* Only try to handle MIME if this is set */
extern char *mboxext;		/* filename extension for mailboxes */
extern char *mailqdir;		/* dir for spooling outgoing mail */

extern PHTL mbox;		/* Mailbox: linked list of PHTLs */
extern FILE *mfile;		/* File pointer to current mailbox file */
extern int nmsgs;		/* Number of messages in this mailbox */
extern BOOL mbchanged;		/* Have we changed the current mailbox? */
extern char notename[];		/* Name of current mailbox */

extern char *homedir;		/* user's home directory */
extern char *fullname;		/* full name of this user from rc file */
extern int used_mailsystem;	/* SYS_HAM or SYS_UUCP */
extern int col_normal;		/* Normal colour attribute */
extern int col_enhanc;		/* Enhanced, errors etc. */
extern int col_select;		/* Selected message in menu */
extern int col_system;		/* Attribute at startup */
extern int col_hilite;		/* Highlighted Letters etc. */
extern int col_heading;		/* Heading colour attribute */

/* version.c */
extern const char myversion[];

#endif /* PCOAK_H_INC */
