/*
  This source is part of PCOak, an electronic mailer for DOS based on PCElm.

  PCElm is Copyright (c) 1988-1993 Martin Freiss and Wolfgang Siebeck
           Copyright (c) 1992-1999 Demon Internet
  PCOak is Copyright (c) 2000-2001 Simon Turner, Pete Disdale and dispc members

  Thanks to an agreement between the original PCElm authors and Demon Internet
  made in late 1999:

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License, version 1, as
	published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	See the file COPYING, which contains a copy of the GNU General
	Public License.
*/

/*
 * Global strings used in various places
 *
 * This is basically a repository for string constants that are used in more
 * than one file, to save memory.  Borland C++ 3.1 can merge several identical
 * strings in a single module together, so multiple identical strings in a
 * single file are OK; but this doesn't work with strings used in more than
 * one file.  Such strings are collected together here (with helpful names) so
 * that they can be used in various different source files.
 *
 * One point about multiple identical strings in the same source file:
 * although having the strings all written out in situ looks nice, it runs the
 * risk that one (and only one) of them will get changed without the others
 * getting changed to match, which IMHO is a Bad Thing (not least because it
 * will increase program size, since the strings will no longer all be
 * identical).
 */

const char file_err[]      = "File error";
const char cant_create[]   = "Can't create ";
const char cant_open[]     = "Can't open ";
const char tempfile_err[]  = "Error opening tempfile";
const char no_tmpfile[]    = "Couldn't create temp file";
const char no_mail[]       = "No mail";
const char no_mem[]        = "Not enough memory";
const char search_prompt[] = "Search for what? ";
const char somebody[]      = "Somebody";
const char aborted[]       = "Aborted";
const char bracket_none[]  = "(none)";
const char message_done[]  = "Message done";
const char cant_savescr[]  = "* * * Can't save screen\r\n";
const char copying_msg[]   = "copying message";
const char str_builtin[]   = "builtin+";	/* Builtin editor name */
const char str_sent[]      = "sent";		/* "sent" folder name */
const char str_recd[]      = "received";	/* "received" folder name */

const char enc_7bit[]      = "7bit";
const char enc_8bit[]      = "8bit";
const char enc_binary[]    = "binary";
const char enc_qp[]        = "quoted-printable";
const char enc_base64[]    = "base64";

const char wrkfileext[]    = ".wrk";	/* extension for queue .WRK files */
const char lckfileext[]    = ".lck";	/* extension for lock files */

#if 0
extern const char file_err[];		/* "File error" */
extern const char cant_create[];	/* "Can't create " */
extern const char cant_open[];		/* "Can't open " */
extern const char tempfile_err[];	/* "Error opening tempfile" */
extern const char no_tmpfile[];		/* "Couldn't create temp file" */
extern const char no_mail[];		/* "No mail" */
extern const char no_mem[];		/* "Not enough memory" */
extern const char search_prompt[];	/* "Search for what? " */
extern const char somebody[];		/* "Somebody" */
extern const char aborted[];		/* "Aborted" */
extern const char bracket_none[];	/* "(none)" */
extern const char message_done[];	/* "Message done" */
extern const char cant_savescr[];	/* "* * * Can't save screen\r\n" */
extern const char copying_msg[];	/* "copying message" */
extern const char str_builtin[];	/* "builtin+" */
extern const char str_sent[];		/* "sent" */
extern const char str_recd[];		/* "received" */
extern const char enc_7bit[];		/* "7bit" */
extern const char enc_8bit[];		/* "8bit" */
extern const char enc_binary[];		/* "binary" */
extern const char enc_qp[];		/* "quoted-printable" */
extern const char enc_base64[];		/* "base64" */
extern const char wrkfileext[];		/* ".wrk" */
extern const char lckfileext[];		/* ".lck" */
#endif
