/*
  This source is part of PCOak, an electronic mailer for DOS based on PCElm.

  PCElm is Copyright (c) 1988-1993 Martin Freiss and Wolfgang Siebeck
           Copyright (c) 1992-1999 Demon Internet
  PCOak is Copyright (c) 2000 Simon Turner, Pete Disdale and dispc members

  Thanks to an agreement between the original PCElm authors and Demon Internet
  made in late 1999:

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License, version 1, as
	published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	See the file COPYING, which contains a copy of the GNU General
	Public License.
*/

/*
 * system.c -- replacement for Borland system() which swaps to EMS/XMS/disk
 *
 * Uses Thomas Wagner's public domain system:
 *	spawn.asm, checkpat.h, checkpat.asm, exec.h, exec.c
 *
 * Based on the system() function from the Demon Internet version of Snews,
 * as modified by John Washington, Dave Scott et al.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "exec.h"
#include "ustring.h"
#include "chars.h"

void errorbox(const char *title, ...);

int system(const char *cmd)
{
    char *p, *q;		/* -> command and parameters */
    int rc;			/* return value */

    if (cmd[0] == '\0')		/* null command: run the shell */
	return do_exec("", "", USE_ALL, 0xffff, NULL);

    if ((p = strdup(cmd)) == NULL)	/* out of memory */
	return 0x102;

    q = first_lwsp(p);		/* find first linear-whitespace char */

    if (*q != '\0')		/* command has some whitespace */
	*q++ = '\0';		/* terminate <p> string, move up to params */

    rc = do_exec(p, q, USE_ALL, 0xffff, NULL);

    if ((unsigned) rc > 0xff)	/* do_exec() failed */
    {
	char errbuf[128];

	AUSTRLCPY5(errbuf, "  \"", p, " ", q, "\"  ");
	errorbox("system() error", "Unable to run command:", errbuf, NULL);
    }

    free(p);
    return rc;
}
