/*
  This source is part of PCOak, an electronic mailer for DOS based on PCElm.

  PCElm is Copyright (c) 1988-1993 Martin Freiss and Wolfgang Siebeck
           Copyright (c) 1992-1999 Demon Internet
  PCOak is Copyright (c) 2000-2001 Simon Turner, Pete Disdale and dispc members

  Thanks to an agreement between the original PCElm authors and Demon Internet
  made in late 1999:

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License, version 1, as
	published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	See the file COPYING, which contains a copy of the GNU General
	Public License.
*/

/*
 * @(#)wildmat.c 1.3 87/11/06	Public Domain.
 *
From: rs@mirror.TMC.COM (Rich Salz)
Newsgroups: net.sources
Subject: Small shell-style pattern matcher
Message-ID: <596@mirror.TMC.COM>
Date: 27 Nov 86 00:06:40 GMT

There have been several regular-expression subroutines and one or two
filename-globbing routines in mod.sources.  They handle lots of
complicated patterns.  This small piece of code handles the *?[]\
wildcard characters the way the standard Unix(tm) shells do, with the
addition that "[^.....]" is an inverse character class -- it matches
any character not in the range ".....".  Read the comments for more
info.

For my application, I had first ripped off a copy of the "glob" routine
from within the find(1) source, but that code is bad news:  it recurses
on every character in the pattern.  I'm putting this replacement in the
public domain.  It's small, tight, and iterative.  Compile with -DTEST
to get a test driver.  After you're convinced it works, install in
whatever way is appropriate for you.

I would like to hear of bugs, but am not interested in additions; if I
were, I'd use the code I mentioned above.
*/
/*
**  Do shell-style pattern matching for ?, \, [], and * characters.
**  Might not be robust in face of malformed patterns; e.g., "foo[a-"
**  could cause a segmentation violation.
**
**  Written by Rich $alz, mirror!rs, Wed Nov 26 19:03:17 EST 1986.
*/

/*
 * Modified 6Nov87 by John Gilmore (hoptoad!gnu) to return a "match"
 * if the pattern is immediately followed by a "/", as well as \0.
 * This matches what "tar" does for matching whole subdirectories.
 *
 * The "*" code could be sped up by only recursing one level instead
 * of two for each trial pattern, perhaps, and not recursing at all
 * if a literal match of the next 2 chars would fail.
 */

/* Modified by Anders Klemets to take an array of pointers as an optional
   argument. Each part of the string that matches '*' is returned as a
   null-terminated, malloced string in this array.
 */

/*  GeK - from wildmat(3) man page

     Robert  Elz  <kre@munnari.oz.au>  added  minus  sign  and  close  bracket
     handling in June, 1991.
 */

/*  GeK - abort code comment from INN 1.4unoff4 and INN 1.5.1 lib/wildmat.c

**  Special thanks to Lars Mathiesen <thorinn@diku.dk> for the ABORT code.
**  This can greatly speed up failing wildcard patterns.  For example:
**      pattern: -*-*-*-*-*-*-12-*-*-*-m-*-*-*
**      text 1:  -adobe-courier-bold-o-normal--12-120-75-75-m-70-iso8859-1
**      text 2:  -adobe-courier-bold-o-normal--12-120-75-75-X-70-iso8859-1
**  Text 1 matches with 51 calls, while text 2 fails with 54 calls.  Without
**  the ABORT code, it takes 22310 calls to fail.  Ugh.  The following
**  explanation is from Lars:
**  The precondition that must be fulfilled is that DoMatch will consume
**  at least one character in text.  This is true if *p is neither '*' nor
**  '\0'.)  The last return has ABORT instead of FALSE to avoid quadratic
**  behaviour in cases like pattern "*a*b*c*d" with text "abcxxxxx".  With
**  FALSE, each star-loop has to run to the end of the text; with ABORT
**  only the last one does.
**
**  Once the control of one instance of DoMatch enters the star-loop, that
**  instance will return either TRUE or ABORT, and any calling instance
**  will therefore return immediately after (without calling recursively
**  again).  In effect, only one star-loop is ever active.  It would be
**  possible to modify the code to maintain this context explicitly,
**  eliminating all recursive calls at the cost of some complication and
**  loss of clarity (and the ABORT stuff seems to be unclear enough by
**  itself).  I think it would be unwise to try to get this into a
**  released version unless you have a good test data base to try it out
**  on.
*/

/************************************************************************
*   $Id: wildmat.c 1.3 1996/11/10 21:53:08 Graham Exp Graham $
*   Jul 93  1.2 GT	Fix warnings.					*
*   Nov 96  1.3 GeK	Additions from wildmat(3) (INN1.4unoff4) to	*
*			handle '-' & ']' within [...]                   *
*   Jun 97  1.4 GeK	Added ABORT code from INN wildmat, optimized	*
*			to remove need for (broken) Star() function,	*
*			core function renamed DoMatch(), added new	*
*			wildmat() user entry point, configurable	*
*			conditionals, tidied test routine		*
*   Jul 97  1.5 PD	Got rid of all the 'argv' stuff but replaced    *
*			3rd param with a case-sensitivity flag		*
*			(v. 'grep'-specific).                           *
*   Nov 00  1.6 PD	Minor tweak to '\' processing to force an exact *
*			match on next char regardless of setting of	*
*			case-insensitivity flag.			*
*   Aug 01  1.7 SCT	Restored ANSI C prototypes; restored register	*
*			ints in DoMatch(); tidied space/tab mess; made	*
*			to lint cleanly under PC-lint 7.5		*
*************************************************************************/

#define FALSE	0
#define TRUE	1

/* I don't trust the _ctype[] macros with signed chars.. */
/* Fair point, but (a) PCOak uses unsigned chars, and (b) the BC++ 3.1
   tolower() casts to unsigned before using _ctype[] ...  -ST */
#define lwr(c)	(((c)<'A'||(c)>'Z')?(c):(c)|('a'-'A'))

#ifdef	TEST
#include <stdio.h>
#include <stdlib.h>
#endif	/* TEST */

#define ABORT	(-1)

static int DoMatch(register const char *s, register const char *p, int f)
{
    register int  last;
    register int  matched;
    register int  reverse;

#ifdef	TEST
    printf("  DoMatch p='%s' s='%s'\n", p, s);
#endif

    for ( ; *p; s++, p++)
    {
	if (*s == '\0' && *p != '*')
	    return ABORT;

	switch (*p)
	{
	    case '\\':
		/* Literal (exact) match with following character */
		if (*s == *++p)
		    break;

		return FALSE;

	    default:
		if (f)
		{
		    if (lwr(*s) == lwr(*p))
			break;
		}
		else
		{
		    if (*s == *p)
			break;
		}
		return FALSE;

	    case '?':
		/* Match anything. */
		if (*s == '\0')
		    return FALSE;
		continue;

	    case '*':
		while (*++p == '*')
		    /* Consecutive stars act just like one. */
		    continue;	/* with the while (*++p) */

		if (*p == '\0')
		    /* Trailing star matches everything. */
		    return TRUE;

		while (*s)
		    if ((matched = DoMatch(s++, p, f)) != FALSE)
			return matched;

		return ABORT;

	    case '[':
		/* [^....] means inverse character class. */
		if ((reverse = (p[1] == '^') ? TRUE : FALSE) != 0)
		    p++;

		matched = FALSE;
		if (p[1] == ']' || p[1] == '-')
		    if (*++p == *s)
			matched = TRUE;

		for (last = *p; *++p && *p != ']'; last = *p)
		{
		    if (!matched)   /* don't unset a previous match */
		    {
			if (*p == '-' && p[1] != ']')
			{
			    matched = (*s <= *++p && *s >= last) ? TRUE : FALSE;
			    continue;
			}

			matched = (*s == *p) ? TRUE : FALSE;
		    }
		}

		if (matched == reverse)
		    return FALSE;
	}
    }

    return (*s == '\0') ? TRUE : FALSE;
}


int wildmat(const char *text, const char *p, int ignore_case)
{
    return (DoMatch(text, p, ignore_case) == TRUE);
}


#ifdef	TEST
int main(void)
{
    char pattern[80];
    char text[80];
    int ic;

    for (;;)
    {
	printf("Enter pattern:  ");
	fflush(stdout);
	if (gets(pattern) == NULL || *pattern == '\0')
	    break;

	printf("Ignore case ?:  ");
	fflush(stdout);
	if (gets((char *)&ic) == NULL || *(char *)ic == '\0')
	    break;

	ic = lwr(ic) == 'y';

	while (TRUE)
	{
	    printf("Enter text:  ");
	    fflush(stdout);
	    if (gets(text) == NULL)
		exit(0);

	    if (*text == '\0')
		/* Blank line; go back and get a new pattern. */
		break;

	    printf("%8d\n", wildmat(text, pattern, ic));
	}
    }

    return 0;
}
#endif	/* TEST */
